/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryHeroMaker;

import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryItem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.ImageIcon;

public class Hero
extends LegendaryItem
implements Comparator<Hero>,
Comparable<Hero> {
    public String name;
    public List<HeroCard> cards = new ArrayList<HeroCard>();
    public boolean changed;
    public String imagePath;
    public double imageZoom = 1.0;
    public int imageOffsetX = 0;
    public int imageOffsetY = 0;
    public String dividerIconEnum = null;
    public ImageIcon imageSummary;

    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    public String generateOutputString(boolean fullExport) {
        String str = "";
        str = String.valueOf(str) + "HERO;" + this.name + "\n\n";
        if (this.imagePath != null) {
            str = String.valueOf(str) + "HFIMAGEPATH;" + this.imagePath + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "HFIMAGEZOOM;" + this.imageZoom + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "HFIMAGEOFFSETX;" + this.imageOffsetX + "\n";
        }
        if (this.imagePath != null) {
            str = String.valueOf(str) + "HFIMAGEOFFSETY;" + this.imageOffsetY + "\n";
        }
        str = String.valueOf(str) + "\n";
        for (HeroCard hc : this.cards) {
            str = String.valueOf(str) + hc.generateOutputString(fullExport) + "\n";
        }
        str = String.valueOf(str) + "\n";
        return str;
    }

    @Override
    public int compareTo(Hero o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public int compare(Hero o1, Hero o2) {
        return o1.name.compareTo(o2.name);
    }

    public String analyseHero() {
        String str = "";
        int totalNumberOfCards = 0;
        int totalNumberOfUniqueCards = 0;
        int totalNumberOfHeroCards = 0;
        HashMap<Object, Integer> cardRarityHash = new HashMap<Object, Integer>();
        HashMap<Object, Integer> teamHash = new HashMap<Object, Integer>();
        HashMap<Object, Integer> powerHash = new HashMap<Object, Integer>();
        HashMap<Object, Integer> triggerHash = new HashMap<Object, Integer>();
        int totalBaseAttack = 0;
        int totalAttackCards = 0;
        HashMap<Object, Integer> baseAttackHash = new HashMap<Object, Integer>();
        int totalBaseRecruit = 0;
        int totalRecruitCards = 0;
        HashMap<Object, Integer> baseRecruitHash = new HashMap<Object, Integer>();
        int totalBaseCost = 0;
        int totalCostCards = 0;
        HashMap<Object, Integer> baseCostHash = new HashMap<Object, Integer>();
        for (HeroCard hc : this.cards) {
            Integer baseCost;
            Integer baseRecruit;
            totalNumberOfCards += hc.rarity.getCount();
            ++totalNumberOfUniqueCards;
            totalNumberOfHeroCards += hc.rarity.getCount();
            this.updateCount(cardRarityHash, (Object)hc.rarity, hc.rarity.getCount());
            this.updateCount(teamHash, hc.cardTeam, hc.rarity.getCount());
            this.updateCount(powerHash, hc.cardPower, hc.rarity.getCount());
            for (String tr : hc.getTriggers()) {
                this.updateCount(triggerHash, tr, hc.rarity.getCount());
            }
            Integer baseAttack = hc.getBaseAttack();
            if (baseAttack != null) {
                if (baseAttack > 0) {
                    totalAttackCards += hc.rarity.getCount();
                }
                totalBaseAttack += hc.getBaseAttack() * hc.rarity.getCount();
                this.updateCount(baseAttackHash, hc.getBaseAttack(), hc.rarity.getCount());
            }
            if ((baseRecruit = hc.getBaseRecruit()) != null) {
                if (baseRecruit > 0) {
                    totalRecruitCards += hc.rarity.getCount();
                }
                totalBaseRecruit += hc.getBaseRecruit() * hc.rarity.getCount();
                this.updateCount(baseRecruitHash, hc.getBaseRecruit(), hc.rarity.getCount());
            }
            if ((baseCost = hc.getBaseCost()) == null) continue;
            if (baseCost > 0) {
                totalCostCards += hc.rarity.getCount();
            }
            totalBaseCost += hc.getBaseCost() * hc.rarity.getCount();
            this.updateCount(baseCostHash, hc.getBaseCost(), hc.rarity.getCount());
        }
        DecimalFormat f = new DecimalFormat("##.##");
        str = String.valueOf(str) + "--------------------------\n";
        str = String.valueOf(str) + "HERO: " + this.name + "\n";
        str = String.valueOf(str) + "--------------------------\n";
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Number of Unique Cards: " + totalNumberOfUniqueCards + "\n";
        str = String.valueOf(str) + "Number of Cards: " + totalNumberOfCards + "\n";
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Card Rarity Counts:\n";
        str = String.valueOf(str) + this.printHash(cardRarityHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Team Counts:\n";
        str = String.valueOf(str) + this.printHash(teamHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Power Counts:\n";
        str = String.valueOf(str) + this.printHash(powerHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Trigger Counts:\n";
        str = String.valueOf(str) + this.printHash(triggerHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Total Base Attack: " + totalBaseAttack + "\n";
        str = String.valueOf(str) + "Average Base Attack Per Card (Including 0 Attack): " + f.format((double)totalBaseAttack / (double)totalNumberOfCards) + "\n";
        str = String.valueOf(str) + "Average Base Attack Per Card (Not Including 0 Attack): " + f.format((double)totalBaseAttack / (double)totalAttackCards) + "\n";
        str = String.valueOf(str) + "Cards by Base Attack:\n";
        str = String.valueOf(str) + this.printHash(baseAttackHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Total Base Recruit: " + totalBaseRecruit + "\n";
        str = String.valueOf(str) + "Average Base Recruit Per Card (Including 0 Recruit): " + f.format((double)totalBaseRecruit / (double)totalNumberOfCards) + "\n";
        str = String.valueOf(str) + "Average Base Recruit Per Card (Not Including 0 Recruit): " + f.format((double)totalBaseRecruit / (double)totalRecruitCards) + "\n";
        str = String.valueOf(str) + "Cards by Base Recruit:\n";
        str = String.valueOf(str) + this.printHash(baseRecruitHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        str = String.valueOf(str) + "Total Base Cost: " + totalBaseCost + "\n";
        str = String.valueOf(str) + "Average Base Cost Per Card (Including 0 Cost): " + f.format((double)totalBaseCost / (double)totalNumberOfCards) + "\n";
        str = String.valueOf(str) + "Average Base Cost Per Card (Not Including 0 Cost): " + f.format((double)totalBaseCost / (double)totalCostCards) + "\n";
        str = String.valueOf(str) + "Cards by Base Cost:\n";
        str = String.valueOf(str) + this.printHash(baseCostHash, totalNumberOfHeroCards);
        str = String.valueOf(str) + "\n";
        return str;
    }

    public void updateCount(HashMap<Object, Integer> hash, Object obj, int value) {
        Integer i = hash.get(obj);
        if (i == null) {
            i = new Integer(0);
        }
        i = new Integer(i + value);
        hash.put(obj, i);
    }

    public String printHash(HashMap<Object, Integer> hash, Integer total) {
        DecimalFormat f = new DecimalFormat("##.##");
        String str = "";
        Set<Map.Entry<Object, Integer>> set = new TreeMap<Object, Integer>(hash).entrySet();
        for (Map.Entry<Object, Integer> entry : set) {
            str = String.valueOf(str) + entry.getKey().toString() + ": " + entry.getValue();
            if (total != null) {
                str = String.valueOf(str) + " (" + f.format(Hero.getPercentageValue(entry.getValue(), total)) + "%)";
            }
            str = String.valueOf(str) + "\n";
        }
        return str;
    }

    public static double getPercentageValue(int value, int max) {
        return (double)value / (double)max * 100.0;
    }
}

